unit uTestKalkulatora;

interface

uses
  uKalkulator, DUnitX.TestFramework;

type
  [TestFixture]
  TTestyKalkulatora = class
  private
    WartoOczekiwana, WartoRzeczywista: integer;
    Kalkulator: TKalkulator;
    [Setup]
    procedure Setup;
    [TearDown]
    procedure TearDown;
  public
    [Test]
    procedure TestProstegoDodawania;
    [Test]
    procedure DodawanieJedenPlusJedenMusiDaWynikDwa;
    [Test]
    procedure TestDodawaniaZera;
    [Test]
    procedure TestDodawaniaDwchLiczbUjemnych;
  end;

implementation

procedure TTestyKalkulatora.Setup;
begin
  Kalkulator := TKalkulator.Create;
end;

procedure TTestyKalkulatora.TearDown;
begin
  Kalkulator.Free;
end;

procedure TTestyKalkulatora.TestProstegoDodawania;
begin
  WartoOczekiwana := 4;
  WartoRzeczywista := Kalkulator.Dodaj(2, 2);
  Assert.AreEqual(WartoOczekiwana, WartoRzeczywista, 'Kalkulator sdzi, e 2 + 2 nie rwna si 4!');
end;

procedure TTestyKalkulatora.DodawanieJedenPlusJedenMusiDaWynikDwa;
begin
  WartoOczekiwana := 2;
  WartoRzeczywista := Kalkulator.Dodaj(1, 1);
  Assert.AreEqual(WartoOczekiwana, WartoRzeczywista, 'Kalkulator sdzi, e 1 + 1 nie rwna si 2!');
end;

procedure TTestyKalkulatora.TestDodawaniaZera;
begin
  WartoOczekiwana := 4;
  WartoRzeczywista := Kalkulator.Dodaj(4, 0);
  Assert.AreEqual(WartoOczekiwana, WartoRzeczywista, 'Kalkulator sdzi, e 4 + 0 nie rwna si 4!');
end;

procedure TTestyKalkulatora.TestDodawaniaDwchLiczbUjemnych;
begin
  WartoOczekiwana := -4;
  WartoRzeczywista := Kalkulator.Dodaj(-2, -2);
  Assert.AreEqual(WartoOczekiwana, WartoRzeczywista, 'Funkcja Dodaj nie wie, e -2 + -2 rwna si -4');
end;

initialization
  TDUnitX.RegisterTestFixture(TTestyKalkulatora);

end.

